<?xml version="1.0" encoding="UTF-8"?>
<!-- ILCD Format Version 1.1_SNAPSHOT Tools Build 1016 -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:edoc="http://www.iai.fzk.de/lca/edoc" xmlns:process="http://lca.jrc.it/ILCD/Process"
  xmlns:lciamethod="http://lca.jrc.it/ILCD/LCIAMethod" xmlns:flow="http://lca.jrc.it/ILCD/Flow" xmlns:flowproperty="http://lca.jrc.it/ILCD/FlowProperty"
  xmlns:unitgroup="http://lca.jrc.it/ILCD/UnitGroup" xmlns:source="http://lca.jrc.it/ILCD/Source" xmlns:contact="http://lca.jrc.it/ILCD/Contact"
  xmlns:locations="http://lca.jrc.it/ILCD/Locations" xmlns:categories="http://lca.jrc.it/ILCD/Categories" xmlns:old_process="http://lca.jrc.it/ELCD/Process"
  xmlns:old_lciamethod="http://lca.jrc.it/ELCD/LCIAMethod" xmlns:old_flow="http://lca.jrc.it/ELCD/Flow" xmlns:old_flowproperty="http://lca.jrc.it/ELCD/FlowProperty"
  xmlns:old_unitgroup="http://lca.jrc.it/ELCD/UnitGroup" xmlns:old_source="http://lca.jrc.it/ELCD/Source" xmlns:old_contact="http://lca.jrc.it/ELCD/Contact"
  xmlns:old_locations="http://lca.jrc.it/ELCD/Locations" xmlns:old_categories="http://lca.jrc.it/ELCD/Categories" xmlns:old_common="http://lca.jrc.it/ELCD/Common"
  xmlns:common="http://lca.jrc.it/ILCD/Common" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xml="http://www.w3.org/XML/1998/namespace"
  xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:mig="http://iai.fzk.de/lca/ILCD/migrate"
  exclude-result-prefixes="edoc old_process old_lciamethod old_flow old_flowproperty old_unitgroup old_contact old_source old_locations old_categories old_common process lciamethod flow flowproperty unitgroup contact source locations categories xml xsi xs">

  <xsl:import href="../../stylesheets/common.xsl"/>

  <xsl:template name="mapCategories">
    <xsl:param name="dsType"/>
    <xsl:param name="catName"/>
    <xsl:param name="level"/>

    <xsl:variable name="dsShortName">
      <xsl:call-template name="determineDataSetShortName"/>
    </xsl:variable>

    <xsl:variable name="isElementaryFlow">
      <xsl:call-template name="isElementaryFlow">
        <xsl:with-param name="datasetShortName" select="$dsShortName"/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:variable name="dsMappingType">
      <xsl:choose>
        <xsl:when test="$isElementaryFlow!='true'">
          <xsl:value-of select="$dsShortName"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="'ElementaryFlow'"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>

    <xsl:variable name="topCategory" select="parent::*/old_common:category[@level='0']/text()"/>
    <xsl:variable name="classElementName">
      <xsl:choose>
        <xsl:when test="$isElementaryFlow='true'">category</xsl:when>
        <xsl:otherwise>class</xsl:otherwise>
      </xsl:choose>      
    </xsl:variable>
    
    <xsl:choose>
      <xsl:when
        test="count(document('category_mappings_1.0.1_to_1.1.xml')/categoryMapping/mappings[@type=$dsMappingType]/map[@level=$level and @name=$catName and (not(@topCategory) or @topCategory=$topCategory)])>0">
        <xsl:for-each
          select="document('category_mappings_1.0.1_to_1.1.xml')/categoryMapping/mappings[@type=$dsMappingType]/map[@level=$level and @name=$catName and (not(@topCategory) or @topCategory=$topCategory)]">
          <xsl:element name="{concat('common:',$classElementName)}" namespace="http://lca.jrc.it/ILCD/Common">
            <xsl:attribute name="level">
              <xsl:value-of select="@targetLevel"/>
            </xsl:attribute>
            <xsl:value-of select="@targetName"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{concat('common:',$classElementName)}" namespace="http://lca.jrc.it/ILCD/Common">
          <xsl:copy-of select="@*"/>
          <xsl:copy-of select="text()"/>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
