<?xml version="1.0" encoding="UTF-8"?>
<!-- ILCD Format Version 1.1_SNAPSHOT Tools Build 1016 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common" xmlns:categories="http://lca.jrc.it/ILCD/Categories"
    xmlns:locations="http://lca.jrc.it/ILCD/Locations" xmlns:lciamethodologies="http://lca.jrc.it/ILCD/LCIAMethodologies" xmlns:process="http://lca.jrc.it/ILCD/Process"
    xmlns:lciamethod="http://lca.jrc.it/ILCD/LCIAMethod" xmlns:flow="http://lca.jrc.it/ILCD/Flow" xmlns:flowproperty="http://lca.jrc.it/ILCD/FlowProperty"
    xmlns:unitgroup="http://lca.jrc.it/ILCD/UnitGroup" xmlns:source="http://lca.jrc.it/ILCD/Source" xmlns:contact="http://lca.jrc.it/ILCD/Contact"
    xmlns:common="http://lca.jrc.it/ILCD/Common">

    <xsl:import href="common.xsl"/>
    
    <xsl:param name="regionalizationLocations">
        <xsl:copy-of select="document('EF_Regionalization_Locations_Reference.xml')"/>
    </xsl:param>
    
     <xsl:template name="checkFieldsProcessEF">
        
         <xsl:call-template name="checkDQI">
             <xsl:with-param name="indicatorName" select="'Technological representativeness'"/>
         </xsl:call-template>
         <xsl:call-template name="checkDQI">
             <xsl:with-param name="indicatorName" select="'Time representativeness'"/>
         </xsl:call-template>
         <xsl:call-template name="checkDQI">
             <xsl:with-param name="indicatorName" select="'Geographical representativeness'"/>
         </xsl:call-template>
         <xsl:call-template name="checkDQI">
             <xsl:with-param name="indicatorName" select="'Completeness'"/>
         </xsl:call-template>
         <xsl:call-template name="checkDQI">
             <xsl:with-param name="indicatorName" select="'Precision'"/>
         </xsl:call-template>
         <xsl:call-template name="checkDQI">
             <xsl:with-param name="indicatorName" select="'Methodological appropriateness and consistency'"/>
         </xsl:call-template>
         <xsl:call-template name="checkDQI">
             <xsl:with-param name="indicatorName" select="'Overall quality'"/>
         </xsl:call-template>
         
         <xsl:call-template name="checkLocationsForFlowRegionalization"/>
         
    </xsl:template>


    <xsl:template name="checkDQI">
        <xsl:param name="indicatorName"/>
               
        <!-- todo: check individually for each of those reviews -->
        <xsl:variable name="DQIvalue" select="process:modellingAndValidation/process:validation/process:review[@type='Accredited third party review' or @type='Independent external review' or @type='Independent review panel']/common:dataQualityIndicators/common:dataQualityIndicator[@name=$indicatorName]/@value"/>
        
        <xsl:choose>
            <xsl:when test="string($DQIvalue)=''">
                <xsl:call-template name="validationEvent">
                    <xsl:with-param name="fancyMessages" select="$fancyMessages"/>
                    <xsl:with-param name="message">Data Quality Indicator for <xsl:value-of select="$indicatorName"/> must be present.</xsl:with-param>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>            
                    <xsl:when test="$DQIvalue='Very good' or $DQIvalue='Good' or $DQIvalue='Fair'">
                        <!-- we're good -->
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="validationEvent">
                            <xsl:with-param name="fancyMessages" select="$fancyMessages"/>
                            <xsl:with-param name="message">Data Quality Indicator for <xsl:value-of select="$indicatorName"/> must be either "Very good", "Good" or "Fair", but is "<xsl:value-of select="$DQIvalue"/>".</xsl:with-param>
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose>    
        
    </xsl:template>



    <!-- all datasets: EF regionalization locations -->

    <xsl:template name="checkLocationsForFlowRegionalization">
    
        <xsl:for-each select="/process:processDataSet/process:exchanges/process:exchange/process:location">
            <xsl:call-template name="checkLocationSpecial">
                <xsl:with-param name="messageSuffix" select="'exchange'"/>
            </xsl:call-template>
        </xsl:for-each>

        <xsl:for-each select="/lciamethod:LCIAMethodDataSet/lciamethod:characterisationFactors/lciamethod:factor/lciamethod:location">
            <xsl:call-template name="checkLocationSpecial">
                <xsl:with-param name="messageSuffix" select="'exchange'"/>
            </xsl:call-template>
        </xsl:for-each>
        
    </xsl:template>

    <!-- we need to override the regular locations checks -->
    <xsl:template match="/process:processDataSet/process:exchanges/process:exchange/process:location" priority="100"/>
    
    <xsl:template match="/lciamethod:LCIAMethodDataSet/lciamethod:characterisationFactors/lciamethod:factor/lciamethod:location" priority="100"/>


    <xsl:template name="checkLocationSpecial">
        <xsl:param name="messageSuffix"/>
        
        <xsl:variable name="presentLocation" select="."/>
        
        <xsl:if test="count(exslt:node-set($regionalizationLocations)/locations:ILCDLocations/locations:location[@value=$presentLocation])=0 and $presentLocation!=''">
            <xsl:call-template name="validationEvent">
                <xsl:with-param name="type" select="'error'"/>
                <xsl:with-param name="fancyMessages" select="$fancyMessages"/>
                <xsl:with-param name="message">Location "<xsl:value-of select="."/>" is not valid for <xsl:value-of select="$messageSuffix"/></xsl:with-param>
            </xsl:call-template>
        </xsl:if>
        
        
    </xsl:template>
    
</xsl:stylesheet>
