/*
 * Decompiled with CFR 0.152.
 */
package general;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.w3c.dom.Document;

public class Util {
    static final Logger logger = Logger.getLogger(Util.class);
    public static String ILCD = "\\ILCD\\";
    public static String FLOW = "\\flows\\";
    public static String OTHER = "\\other\\";
    public static String processes = "processes";
    public static String folderPackage = "C://";
    public static String folderProcess = "C://";
    public static String mapFile = String.valueOf(OTHER) + "\\MappingDataSet_v2-3.xml";
    public static String mesgErr = "ERROR! during the conversion procedure, one or more exchanges were not properly converted, due to missing destination flows in the package you choose as a reference. Please check that the Reference EF package is the one referred to the current version of the converter (EF 2.0-3.0) ";

    protected static boolean checkIsNumber(String number) {
        try {
            Double.parseDouble(number);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    protected static String formatForLegh(String val, int lengh, String valAdd) {
        while (val.length() < lengh) {
            val = String.valueOf(valAdd) + val;
        }
        return val;
    }

    protected void createExcelFile(String excelName, Workbook workbook, int i) {
        if (Util.createExcelFile(excelName, workbook)) {
            logger.warn(new Date() + ":Create:" + excelName + i);
        }
    }

    protected static boolean fileExit(String string) {
        File f = new File(string);
        return f.exists() && f.canRead();
    }

    protected static String getVal(Cell cell) {
        if (cell != null) {
            switch (cell.getCellType()) {
                case 1: {
                    return cell.getStringCellValue().toLowerCase().trim();
                }
                case 0: {
                    return "" + cell.getNumericCellValue();
                }
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static boolean createExcelFile(String excelName, Workbook workbook) {
        boolean ret = true;
        File f = new File(excelName);
        if (f.exists()) {
            f.delete();
        }
        while (f.exists()) {
            JOptionPane.showMessageDialog(null, " Close the File:" + excelName);
            f.delete();
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (FileOutputStream outputStream = new FileOutputStream(excelName);){
                    outputStream.flush();
                    workbook.write(outputStream);
                    return ret;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                ret = false;
                if (workbook == null) return ret;
                try {
                    workbook.close();
                    return ret;
                }
                catch (IOException e2) {
                    ret = false;
                }
                return ret;
            }
            catch (Exception e) {
                e.printStackTrace();
                ret = false;
                if (workbook == null) return ret;
                try {
                    workbook.close();
                    return ret;
                }
                catch (IOException e3) {
                    ret = false;
                }
                return ret;
            }
        }
        finally {
            if (workbook != null) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    ret = false;
                }
            }
        }
    }

    protected static void saveNewXml(Document doc, String fileName) throws IOException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(fileName));
        transformer.transform(source, result);
        File filePath = new File(fileName);
        FileInputStream inputS = new FileInputStream(filePath);
        String content = IOUtils.toString((InputStream)inputS, StandardCharsets.UTF_8);
        FileOutputStream outputS = new FileOutputStream(filePath);
        IOUtils.write(content, (OutputStream)outputS, StandardCharsets.UTF_8);
        outputS.close();
        inputS.close();
    }

    protected static void copyRow(Row ra, Row nextRow) {
        int i = 0;
        while (i < nextRow.getLastCellNum()) {
            Cell oldCell = nextRow.getCell(i);
            Cell newCell = ra.createCell(i);
            if (oldCell == null) {
                newCell = null;
            } else {
                if (oldCell.getCellComment() != null) {
                    newCell.setCellComment(oldCell.getCellComment());
                }
                if (oldCell.getHyperlink() != null) {
                    newCell.setHyperlink(oldCell.getHyperlink());
                }
                newCell.setCellType(oldCell.getCellType());
                switch (oldCell.getCellType()) {
                    case 3: {
                        newCell.setCellValue(oldCell.getStringCellValue());
                        break;
                    }
                    case 4: {
                        newCell.setCellValue(oldCell.getBooleanCellValue());
                        break;
                    }
                    case 5: {
                        newCell.setCellErrorValue(oldCell.getErrorCellValue());
                        break;
                    }
                    case 2: {
                        newCell.setCellFormula(oldCell.getCellFormula());
                        break;
                    }
                    case 0: {
                        newCell.setCellValue(oldCell.getNumericCellValue());
                        break;
                    }
                    case 1: {
                        newCell.setCellValue(oldCell.getRichStringCellValue());
                    }
                }
            }
            ++i;
        }
    }
}

